﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL.APIMobile.Model
{
    public interface IExerciseDataStub
    {
    }

    public static class Dictionary
    {
        public static string OPEN_GAP = "[*]";
    }

    public static class ExerciseType
    {
        public static string UzupelnianieLukI = "fill_global";//MovingBox
        public static string UzupelnianieLukII = "fill_local";//ComboBox
        public static string UzupelnianieLukIII = "fill_open";//OpenGap
        public static string LaczenieKolumn = "classify_h";//Matching
        public static string Klasyfikacja = "classify_v";// MovingBox_Areas
        public static string PytaniezObrazkiem = "classify_img";
        public static string OpcjeJednokrotnegoWyboru = "question_single";//ABCD
        public static string OpcjeWielokrotnegoWyboru = "question_multi";//ABCD
        public static string Slajd = "text";
        public static string Menu = "menu";
        public static string Auxyliary = "auxyliary";
    }

    /// <summary>
    /// Bazowy obiekt API
    /// </summary>
    public class GExercise
    {
        public long id { get; set; }
        public long unit_id { get; set; }
        public long exercise_id { get; set; }
        public int mode_id { get; set; }
        public string type{ get; set; }
        public string text { get; set; }

        public GExercise() {}

        public GExercise(BL.ZSBELearning.ContextParam ContextParam) 
        {
            if (ContextParam.AuxyliaryPages == BL.Dictionary.AuxyliaryPagesType.None)
            {
                id = ContextParam.ExerciseOut.ID.Value;
                exercise_id = ContextParam.ExerciseOut.ID.Value;
                unit_id = ContextParam.UnitOut.ID.Value;
                mode_id = (int)ContextParam.Mode;
                text = Gemini.Utility.XML.Node.Get.CDATA(ContextParam.ExerciseOut.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Order));

                switch (ContextParam.ExerciseOut.Type)
                {
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.ComboBox_Section: type = ExerciseType.UzupelnianieLukII; break;
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.ComboBox_Text: type = ExerciseType.UzupelnianieLukII; break;
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Questions_ComboBox: type = ExerciseType.UzupelnianieLukII; break;

                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.MovingBox_Section: type = ExerciseType.UzupelnianieLukI; break;
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.MovingBox_Text: type = ExerciseType.UzupelnianieLukI; break;
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Questions_MovingBox: type = ExerciseType.UzupelnianieLukI; break;


                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.OpenGap_Section: type = ExerciseType.UzupelnianieLukIII; break;
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.OpenGap_Text: type = ExerciseType.UzupelnianieLukIII; break;
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Questions_OpenGap: type = ExerciseType.UzupelnianieLukIII; break;

                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Matching: type = ExerciseType.LaczenieKolumn; break;

                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.MovingBox_Points: type = ExerciseType.PytaniezObrazkiem; break;

                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.MovingBox_Areas: type = ExerciseType.Klasyfikacja; break;

                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Text: type = ExerciseType.Slajd; break;

                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Questions_ABCD:
                        {
                            if (Gemini.Utility.XML.Attribute.Get.Int(ContextParam.ExerciseOut.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Questions), PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.IsMultipleChoice, 0) > 0)
                            {
                                type = ExerciseType.OpcjeWielokrotnegoWyboru;
                            }
                            else
                            {
                                type = ExerciseType.OpcjeJednokrotnegoWyboru;
                            }

                            break;
                        }
                }
            }
            else
            {
                if (ContextParam.AuxyliaryPages == BL.Dictionary.AuxyliaryPagesType.CourseMenu)
                {
                    type = ExerciseType.Menu;
                }
                else
                {
                    type = ExerciseType.Auxyliary;
                }

                id = 0;
                exercise_id = 0;
                unit_id = 0;
                mode_id = (int)ContextParam.Mode;
                text = string.Empty;
            }
        }
    }
}
